#ifndef _2INCH9_EPD_H_
#define _2INCH9_EPD_H_

#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include "Arduino.h"

//  *      D7 --> CS
//  *      D13 --> CLK
//  *      D11 --> MOSI
//  *      D10  --> DC
//  *      D9  --> RST
//  *      D8  --> BUSY
//IO settings

#define RST_Pin         9
#define DC_Pin          10
#define CS_Pin          7
#define BUSY_Pin        8

#define black   0x00  /// 00
#define white   0x01  /// 01
#define yellow  0x02  /// 10
#define red     0x03  /// 11

#define EPD_WIDTH   168
#define EPD_HEIGHT  384
#define EPD_ARRAY  EPD_WIDTH*EPD_HEIGHT/4


#define Source_BITS     168
#define Gate_BITS   384
#define ALLSCREEN_BYTES  16128 

#define EPD_W21_MOSI_0  digitalWrite(SDI_Pin,LOW)
#define EPD_W21_MOSI_1  digitalWrite(SDI_Pin,HIGH) 

#define EPD_W21_CLK_0  digitalWrite(SCK_Pin,LOW)
#define EPD_W21_CLK_1  digitalWrite(SCK_Pin,HIGH)


#define EPD_W21_CS_0   digitalWrite(CS_Pin,LOW)
#define EPD_W21_CS_1   digitalWrite(CS_Pin,HIGH)

#define EPD_W21_DC_0   digitalWrite(DC_Pin,LOW)
#define EPD_W21_DC_1   digitalWrite(DC_Pin,HIGH)
#define EPD_W21_RST_0  digitalWrite(RST_Pin,LOW)
#define EPD_W21_RST_1  digitalWrite(RST_Pin,HIGH)
#define isEPD_W21_BUSY digitalRead(BUSY_Pin)

void SPI_Write(unsigned char value);
void Epaper_Write_Data(unsigned char datas);
void Epaper_Write_Command(unsigned char command);

//Full screen refresh display
void EPD_HW_Init(void); 
void EPD_WhiteScreen_White(void);
void EPD_WhiteScreen_Black(void);
void EPD_DeepSleep(void);
void EPD_WhiteScreen_Red(void);
void EPD_WhiteScreen_Yellow(void);
void PIC_display(const unsigned char* picData);       
                         
#endif
